const pollFeedback = require("./poll")
const generateButtons = require("./push")
const deferred = require("jquery-deferred")
const Deferred = deferred.Deferred;

exports = {
  onAppInstallCallback: function() {
    ensureTrigger().then(function() {
      console.log("Installation successful.")
      renderData();
    }, function(err) {
      renderData(err);
    });
  },
  onAppUninstallCallback: function() {
    $schedule.delete({ 
      name: "happy_poll_trigger" 
    }).then(function(data) {
      console.log("Uninstalled polling schedule");
      renderData(null, data);
   }, function(err) {
      console.log("Unable to uninstall polling schedule", err);
      renderData(err);
    });
  },
  scheduledEventHandler: function(args) {
    console.log("Processing schedule event")
    pollFeedback(args);
  },
  ticketUpdateHandler: function(args) {
    ensureTrigger().then(function(){
      // NOP
    }, function(err) {
      console.log("Unable to ensure trigger installed,", err)
      return new Deferred().resolve()
    })
    .then(function() {
      return generateButtons(args);
    })
  },
};

function ensureTrigger() {
  return $schedule.create({
    name: "happy_poll_trigger",
    data: { },
    schedule_at: new Date().toISOString(),
    repeat: {
      time_unit: "minutes",
      frequency: 5
    }
  }).then(function() {
    console.log("Installed polling schedule")
  }, function(err) {
    if(err.message === "This Schedule name already exists") {
      return new Deferred().resolve(err);
    }
    console.log("Unable to install polling schedule", err)
  });
}
