exports = function(context) {
  const value = context.value;
  const lostTime = timeFormatter(context.lostTime);
  const comment = context.comment || "<em>No comment</em>";
  const factors = context.factors ? context.factors.join(", ") : "<em>No factors</em>";
  const profile = capitalize(context.profile || "-");
  const moodColor = value < 7 ? "orange" : value > 8 ? "green-ui" : "teal";
  return `<div style="line-height:1.15;-webkit-text-size-adjust:100%;--gray-light:#edeff4;--gray-700:#616161;--gray-600:#757575;--gray-300:#e0e0e0;--gray-200:#f2f2f2;--gray-100:#f5f5f5;--pink-brand:#ef3f74;--deepblue:#1d253c;--red-ui:#db2719;--green-ui:#007d44;--green-ui-2:#d6f1e6;--teal:#3b5b5e;--teal-2:#e2e6e7;--orange:#ff5b22;--orange-2:#ffe6de;--blue-link:#405dc1;margin-top:0;margin-bottom:0;margin-right:0;margin-left:0;font-family:-apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto,
          Oxygen, Ubuntu, Cantarell, 'Open Sans', 'Helvetica Neue', sans-serif;background-color:var(--gray-light);" >
    <div style="background-color:white;" >
      <div style="margin-top:8px;border-radius:6px;border-width:1px;border-style:solid;border-color:var(--gray-300);display:flex;" >
        <div style="padding-top:8px;padding-bottom:16px;padding-right:16px;padding-left:16px;text-align:left;display:flex;flex-flow:column;width:15%;background-color: var(--${moodColor}-2);color: var(--${moodColor});" >
          <div style="font-size:46px;line-height:114%;letter-spacing:-0.01em;font-weight:600;" >
            <span>${value}</span>
          </div>
          <div style="margin-top:auto;font-size:14px;line-height:130%;font-weight:500;" >
            <div style="margin-top:4px;" >Lost time</div>
            <div style="margin-top:4px;" >${lostTime}</div>
          </div>
        </div>
        <div style="width:85%;padding-top:24px;padding-bottom:24px;padding-right:24px;padding-left:24px;" >
          <div >
            <p style="font-weight:500;font-size:16px;color:var(--deepblue);line-height:130%;margin-top:0;margin-bottom:8px;margin-right:0;margin-left:0;" >
              ${comment}
            </p>
            <p style="color:var(--gray-600);font-weight:300;" >
              ${factors}
            </p>
          </div>
          <div style="margin-top:24px;display:flex;justify-content:space-between;align-items:flex-end;" >
            <div >
              <span style="display:inline-block;color:var(--deepblue);background-color:var(--gray-100);font-size:12px;font-weight:600;padding-top:8px;padding-bottom:8px;padding-right:16px;padding-left:16px;border-radius:9999px;" >${profile}</span>
            </div>
            <a href="https://happysignals.com"><img src="https://assets.happysignals.com/freshservice/happysignals.png" alt="" style="border-style:none;width:120px;" /></a>
          </div>
        </div>
      </div>
    </div>
  </div>`
}

function capitalize(str) {
  return str.substring(0,1).toUpperCase() +str.substring(1);
}

function quantifyTime(value) {
  const days = Math.floor(value / 60 / 8), // 8h in working day
    hours = Math.floor(value / 60) % 8,
    minutes =
      days == 0 && hours == 0 ? (Math.floor(value / 5) * 5) % 60 : days == 0 ? (Math.floor(value / 15) * 15) % 60 : 0;
  return { days, hours, minutes };
}

function timeFormatter(value) {
  if (value < 5) return '0 minutes';
  const { days, hours, minutes } = quantifyTime(value);
  return [
    days === 0 ? '' : days === 1 ? '1 day' : days + ' days',
    hours === 0 ? '' : hours === 1 ? '1 hour' : hours + ' hours',
    minutes === 0 ? '' : minutes === 1 ? '1 minute' : minutes + ' minutes',
  ].join(' ');
}