# HappySignals integration for FreshService

### Mapping fields

Any of the ticket fields or field on the requester may be mapped to parameters that are sent to 
HappySignals. The mapping is described in the `Custom mappings` configuration parameter and is 
specified as a simple line by line mapping with the assigned field on the right and the source field
in a dot-walk type form on the right side.

Any of the normal HappySignals fields may be used for mapping and the source value may be mapped 
either from the ticket fields, the requester, the requesters location or department, or if needed
mapped to a constant value.

### Mapping built in fields

The simplest mapping is from one of the built in ticket fields to a HappySignals field, this is done 
simply by specifying the target HappySignals field, and the source field, separated by an `=` 
(equals) sign on a single line.

    ap5=group_name

In case of ambiguity a complete list of ticket field can be obtained in the helpdesk portal using 
the following url `https://<your_instance>.freshservice.com/ticket_fields.json`. 

### Mapping custom fields

You can also map any custom field using the following format. Source field names can generally be 
formed by replacing any upper case letters with lower case letters, and any spaces with underscore
characters `_` in the field name as follows. 

    ap1=custom_fields.company

When using earlier mentioned of obtaining field names, please note that for custom fields the name 
in the mapping should be the `id` property of the field up until and not including, the last `_` 
(underscore) character.

### Mapping requester fields

Data about the requester is available using a special `@requester` notation, the following shows how 
to map the requesters language to the `lang` parameter in HappySignals

    lang=@requester.language

The requesters location is available by nesting field references. The following mapping would map 
the country field on the requesters locations address to the `co3` parameter corresponding to the 
country field in HappySignals.

    co3=@requester.location.address.country

You can also map one of the requesters departments using an array like notation. The following maps
the requesters first departments name to the `esm` parameter in HappySignals,

    esm=@requester.department[0].name

### Mapping constants

Sometimes there may be a need to map a constant value to one of the parameters, if for example the
company is only active in one country and there is no country data available on the requester. To
map a constant use the `!` (exclamation mark) character to indicate that the value following the
exclamation mark is to be used verbatim.

    co3=!UK

### Fallback on fields

A single HappySignals field may be listed more than once in the mappings to enable fallbacks in case
of missing data in one of the fields.

If for example the requesters address is not always filled out, we can assign a default value of 
"UK" using a constant by specifying two mapping rules for the same field. In this case the last 
mapping which produces a value will take precedence over any previous values.

    co3=!UK
    co3=@requester.location.address.country

This can be used to deconstruct "Dependant field"-fields where the hierarchy is unbalanced.

    co5=custom_fields.service
    co5=custom_fields.service_tier2
    co5=custom_fields.service_tier3

In this case the deepest selected value in hierarchy will be passed as the `co5` parameter to
HappySignals.

# Comments

You may add comments to the mappings in order to document what is sent. Start a comment row with a
`#` character, anything on the comment row is ignored by the application.

    # This is a comment

## Full example

The following example illustrates a few of the possibilities described above in a complete mapping,

    # Send handling group
    ap5=group_name

    # Send the company field from our custom field
    ap1=custom_fields.company

    # Send the requesters language, with english as default
    lang=!en
    lang=@requester.language
    
    # Get the department
    esm=@requester.department[0].name

    # Set country from requesters location, default to UK
    co3=!UK
    co3=@requester.location.address.country

    # Send the most specific service level selected
    co5=custom_fields.service
    co5=custom_fields.service_tier2
    co5=custom_fields.service_tier3


## Formal mapping specification

The following describes the format in a more formal BNF style form.

    SPECIFICATION = ROW*
    ROW = (SPEC_SET | COMMENT)? NEWLINE
    COMMENT = "#" CHAR*
    SPEC_SET = SPEC (',' SPEC)*
    SPEC = DESTINATION_FIELD '=' SOURCE_SPEC
    DESTINATION_FIELD = 'var1' | 'var2' | 'var3' | 'var4' | 
                        'ap1' | 'ap2' | 'ap3' | 'ap4' | 
                        'ap5' | 'ap6' | 'co1' | 'co2' | 
                        'co3' | 'co4' | 'co5' | 'co6' | 
                        'lang' | 't' | 'esm' | 'cat2' | 
                        'cat3' | 'd' | 'sn'
    SOURCE_SPEC = CONST_SPEC | CUSTOM_SPEC | REQUESTER_SPEC | FIELD_SPEC
    CONST_SPEC = '!' CHAR+
    CUSTOM_SPEC = 'custom_field' FIELD_SPEC
    REQUESTER_SPEC = '@requester' (FIELD_SPEC+ | DEPARTMENT_SPEC)
    DEPARTMENT_SPEC = 'department[' NUMERIC+ ']' FIELD_SPEC+
    FIELD_SPEC = '.' (ALPHA | NUMERIC | '_' )+